unit Szgep2u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Panel1: TPanel;
    Edit1: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit2: TEdit;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit3KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Math;

{$R *.DFM}
type
  // Sajt kivtelosztly ltrehozsa
  EMJelHiba = class(ERangeError);

var
  a, b   :  Integer;  // szm1, szm2
  c      :  Integer;  // az eredmny
  op     :  char;     // az opertor

// Adatbevitel
procedure Beolvas;
begin
    op:=Form1.edit2.text[1];
    a:=strtoint(Form1.Edit1.Text);
    b:=strtoint(Form1.Edit3.Text);
end;

// A szmolst vgz fggvny
function Szamol: Integer;
begin
 case op of
    '+': result:=a+b;               // sszeads   }
    '-': result:=a-b;               // kivons     }
    '*': result:=a*b;               // szorzs     }
    '/': result:=a div b;           // osszts     }
    '^': result:=trunc(power(a,b)); // hatvnyozs }
   else
    // Rossz operator esetben sajt kivtel kivltsa
    raise EMJelHiba.Create('A mveletei jel csak +,-,*,/,^ lehet!');
 end;
end;

// A szmtsi eredmnyt megjelent eljrs
procedure Kiir;
begin
  Form1.Edit4.Text:=Inttostr(c);
end;

procedure Calculate;
{ F program }
begin
  try
    Beolvas;
    c:=Szamol;
    Kiir;
  except
     // Kivtelkezelk
     on E: EMJelHiba  do ShowMessage(E.Message);
     on EDivByZero    do ShowMessage('Nullval oszts!');
     on EZeroDivide   do ShowMessage('Nullval oszts!');
     on EIntOverflow  do ShowMessage('Tlcsorduls!');
     on EInvalidOp    do ShowMessage('Matematikai hiba!');
     on EConvertError do ShowMessage('Hibs adatbevitel!');
  else
     // Minden ms kivtel esetn
     ShowMessage('Hiba trtnt!');
  end;
end;

// A Szmols gomb esemnykezelje
procedure TForm1.Button1Click(Sender: TObject);
begin
  Calculate;
  Edit1.Setfocus;
end;

// A vezrlk inicialozlsa
procedure TForm1.FormCreate(Sender: TObject);
begin
  Edit1.Text:='0';
  Edit2.Text:='+';
  Edit3.Text:='0';
  Edit4.Text:='0';
end;

// Kilps
procedure TForm1.Button2Click(Sender: TObject);
begin
  Application.Terminate;
end;

// Az <Enter> billenty kezelse a hrom
// adatbeviteli ablakban
procedure TForm1.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=13 then
   begin
    Edit3.SetFocus;
    Key:=0;
   end;
end;

procedure TForm1.Edit3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=13 then
   begin
    Edit2.SetFocus;
    Key:=0;
  end;
end;

procedure TForm1.Edit2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if key=13 then
   begin
    Button1Click(Sender);
    Key:=0;
  end;
end;

// Ha brmelyik adatbeviteli mez tartalma megvltozik
// trljk az eredmny mezt
procedure TForm1.Edit1Change(Sender: TObject);
begin
  Edit4.Clear;
end;

end.
